	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 *                                                                          *
 * FILE NAME:   IAI_EZMac_Lite_Int.c                                        *
 *                                                                          *
 * DESIGNER:	Lukacs, Miklos; Kovacs, Krisztian                           *
 * PROGRAMMER: Lukacs, Miklos                                               *
 *                                                                          *
 * DESCRIPTION: EZMac internal functions                                    *
 *                                                                          *
 * REVISION:    01_5  Maj  10, 2005     From the original EZmac version     *
 *                                      removed:                            *
 *                                     - Multicast addressing.              *
 *                                     - Network address mode.              *
 *                                     - Reduced address mode.              *
 *                                     - Dynamic packet length.             *
 *                                     - Error detection.                   *
 *                                     - CID is mandatory.                  *
 *              01_6  Aug   11, 2005   FIFO restart after HW error,         *
 *                                     Timer IT handling improvements       *
 *				01_7  Dec	 08, 2005	Port to HiTech						*
 *                                                                          *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#define SM_REAL_FUNCTION

#ifdef SM_REAL_FUNCTION
   #define SM_SOFTWDT_EN              //turn on the software watchdog timers
#ifndef END_HARDWARE
//   #define SM_PRINT_STATE           //debug functions!
   #define SM_DEBUG
#endif
#else
#ifndef END_HARDWARE
   #define SM_DEBUG
   #define SM_PRINT_STATE
//   #define SM_PRINTF
 //  #define SM_PRINTF_TX
#endif
#endif

#ifdef SM_DEBUG
 #define SM_TRIGGER_DQD
// #define SM_TRIGGER_CID
// #define SM_TRIGGER_SID
#define SM_TRIGGER_TX
#endif

//===============================================================================================
#pragma separate
void Ch_Check_Start (bool ChangeFreq)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 static _NEAR__ bool BANK_2 NextFreq;
 static _NEAR__ int BANK_2 Reg;
#endif
#ifdef CCS_C_COMPILER
 bool NextFreq;
 int Reg;
#endif

#ifdef FIX_MEM_ADDRESS
#pragma byte ChangeFreq = 0x63
#pragma bit NextFreq = 0x64.0
#pragma byte Reg = 0x65
#endif

   #ifdef SM_DEBUG
   TRIGGER = 0;
   #endif

   //turn of FIFO of Trixie

   //next states will not read data bytes -> External Interrupt routine should set the SPI select pin
   SetSpiEn = TRUE;
   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Fifo_command] &=0xFFFD;                                        //reset synchron latch
    EZRadio_CMD_Write(Fifo_command);
   #endif
   disable_interrupts( INT_EXT );

   //set the frequency
   if( ChangeFreq && EZ_reg.bits.RCRB.SCHEN )
      {
      Reg = (0xFF >> (7 - EZ_reg.bits.MCRB.NRF));
      //are all of the available frequencys masked?
      if( (EZ_reg.bytes.FMASKB & Reg) == Reg )
         //all of the freq are masked -> failure; the state machine stay in the current frequency
         NextFreq = FALSE;
      else
         NextFreq = TRUE;

      while(NextFreq)
         {
         if( Frequency < EZ_reg.bits.MCRB.NRF )
            {//it isn't the last frequency
            Frequency++;
            if( ((EZ_reg.bytes.FMASKB >> Frequency) & 0x01) == 0 )
               //this frequency isn't masked -> end of search
               NextFreq = FALSE;
            }
         else
            {//go to the first frequency
            Frequency = 0;
            if( ((EZ_reg.bytes.FMASKB >> Frequency) & 0x01) == 0 )
               //this frequency isn't masked -> end of search
               NextFreq = FALSE;
            }
         }
      }
   //if the search of the channel isn't active, set the default frequency
   if( !EZ_reg.bits.RCRB.SCHEN )
      Frequency = (int8)EZ_reg.bits.RCRB.RF;

   //configure Trixie for new freq (Frequency)
   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Freq_command]=0xA000 + ((int16)(EZ_reg.bytes.FR[Frequency]-1)*FREQ_step+FREQ_start);
    EZRadio_CMD_Write(Freq_command);
   #endif

   #ifdef SM_PRINTF
    printf("F: %x\n\r",Frequency);
   #endif
   //set the RSR register to the default value
   EZ_reg.bytes.RSRB = 0;
   //Set the next state
// Changed by Laszlo Kadar on 26.11.05
   EZ_state = EZMac_S_RxDQDCheck;
   EZInternalState = EZ_RxDQDCheck;
   //set the DQD Check init values
   Data = 0;
   Data1 = 0;

   //Start T1 to first DQD check
   _Set_Timer1(FIRST_DQD_TIMER_LIMIT);
}

//===============================================================================================
#pragma separate
bool _DQD_Check (void)
{
#ifdef SM_REAL_FUNCTION
   if( MISO_PIN )
      return 1;
   else
      return 0;
#else
   return TRUE;             //only for debug
#endif
}

//===============================================================================================
#pragma separate
bool _DRSSI_Read (void)
{
   //Read the DRSSI from the Trixie
   SEL_PIN = 0;
   STRH=Spi_Comm0();
   SEL_PIN = 1;
   return (STRH & DRSSI_bit);
}

//===============================================================================================
#pragma separate
void _GotoTxErrorState(void)
{
   #ifdef SM_REAL_FUNCTION
    EZ_commands.arr[Power_command] &= 0xff0f;                                 //switch off Trixie
    EZRadio_CMD_Write(Power_command);
   #endif
   //Set the next state
   EZ_state = EZMac_S_TxError;
   EZInternalState = EZ_TransmitError;
   //disable all IT
   _Turn_Off_Timer1();
   disable_interrupts( INT_EXT );
}

//===============================================================================================
#pragma separate
void _TrixieHWError(void)
{
#ifdef SM_REAL_FUNCTION
   #ifdef SM_DEBUG
    TRIGGER = 0;
   #endif

   //restart Trixie
   disable_interrupts( INT_EXT );

   EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP;
   EZ_commands.arr[Fifo_command]=FIFO_cmd_init_value;             //Fill:synchron pattern; IT level:8; disable sensitive reset
   EZ_commands.arr[Data_Rate_command]=DR_cmd_init_value;        //8842bps
   EZ_commands.arr[RX_Ctrl_command]=RX_cmd_init_value;          // BW:135kHz; VDI:always on; LNA:max; DRSSI:-103; Pin8: VDIout
   EZ_commands.arr[RX_Ctrl_command] &= 0xFFF8;
   EZ_commands.arr[RX_Ctrl_command] |= (int16)((EZ_reg.bytes.RCRB & 0x70) >> 4);

   EZ_commands.arr[TX_Ctrl_command]=TX_cmd_init_value & 0xfff1; //f0+df; df:75kHz; Pout:-3dB!!!!
   EZ_commands.arr[TX_Ctrl_command] &= 0xFFF8;
   EZ_commands.arr[TX_Ctrl_command] |= (int16)((EZ_reg.bytes.TCRB & 0x38) >> 3);

   EZ_commands.arr[Data_Filter_command]=DF_cmd_init_value;      //CR:slow; Digital LPF; DQD:7
   EZ_commands.arr[AFC_command]=AFC_cmd_init_value;              //enabled; fine mode; auto,keep offset; +7/-8; output enabled


   EZRadio_CMD_Write(Config_command);
   EZRadio_CMD_Write(Fifo_command);
   EZRadio_CMD_Write(Data_Rate_command);
   EZRadio_CMD_Write(TX_Ctrl_command);
   EZRadio_CMD_Write(RX_Ctrl_command);
   EZRadio_CMD_Write(Data_Filter_command);
   EZRadio_CMD_Write(AFC_command);

   EZRadio_Statusread ();           //read all IT status bit
#endif

   //next states will not read data bytes -> External Interrupt routine should set the SPI select pin
   SetSpiEn = TRUE;

   //In which state did the failure occured?
   if( EZInternalState > EZ_RxEnd )
      {//during tx -> goto TxError state
      _GotoTxErrorState();
      return;
      }
   if ( (EZInternalState < EZ_TxCheckChannel) && (EZInternalState > EZ_WakeUp) )
      /*changed by mlu for rev1.6 -> after HW error the Rx FIFO wasn't switched on*/
     {//during rx
      //switch on Rx and FIFO
      EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP | FIFO_USED;  //switch on RX FIFO
      EZRadio_Write(EZ_commands.arr[Config_command]);
      EZRadio_Statusread ();
      //goto new freq
      Ch_Check_Start(TRUE);
      return;
      }
   //if else, then stay in the current state
}

//===============================================================================================
#pragma separate
int8 _ReadByte_Trixie(void)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 static _NEAR__ int8 BANK_2 data;
#endif
#ifdef CCS_C_COMPILER
 int8 data;
#endif

   data=Spi_Comm0();
   SEL_PIN = 1;
   return data;
}

//===============================================================================================
#pragma separate
void _WriteByte_Trixie (int8 data)
{
      SEL_PIN = 0;         //SEL=0
      EZ_Spi_Write(0x0B8);
      EZ_Spi_Write(data);
      SEL_PIN = 1;         //SEL=1
}

//===============================================================================================
#ifdef SM_PRINT_STATE
#pragma separate
/*only for debug: put the nukber of the state to the IO ports*/
void _PrintState(void)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 _NEAR__ int8 BANK_2 temp;
#endif
#ifdef CCS_C_COMPILER
 int8 temp;
#endif

   temp = portc_reg.adat;
   temp &= 0xF0;
   temp |= ((EZInternalState & 0x0F));
   portc_reg.adat = temp;
}
#endif

//===============================================================================================
#pragma separate
void State_Machine (char It_Source)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
 static _NEAR__ bool BANK_2 AddrSID, AddrDID, FirstError;
 static _NEAR__ int16 BANK_2 TimerSet;
#endif
#ifdef CCS_C_COMPILER
 bool AddrSID, AddrDID, FirstError;
 int16 TimerSet;
#endif

#ifdef FIX_MEM_ADDRESS
 #pragma byte It_Source = 0x67
 #pragma bit AddrSID = 0x64.1
 #pragma bit AddrDID = 0x64.2
 #pragma bit FirstError = 0x64.3
#endif

#ifdef SM_DEBUG
 LED4 = 1;     //trigger output to measure the State Machine timing
#endif

if( (It_Source == IT_SOURCE_OVUR) || (It_Source == IT_SOURCE_COMM_OVUR) )
   {//Trixie HW error: overrun or underrun!
   _TrixieHWError();
   return;
   }

switch( EZInternalState )
   {
   /*Idle state*/
   case EZ_Idle:
      #ifdef SM_PRINTF
       printf("Idle\n\r");
      #endif
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
   break;

 /*Sleep state*/
   case EZ_Sleep:
      #ifdef SM_PRINTF
       printf("Sleep\n\r");
      #endif
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
   break;

 /*after waking up*/
   case EZ_WakeUp:
      if ( It_Source != IT_SOURCE_T1 )
         {
         //waking up error
         #ifdef SM_PRINTF
          printf("W E\n\r");
         #endif
         _TrixieHWError();
         _Turn_Off_Timer1();
         }
//changed by mlu for rev1.4
      EZ_commands.arr[Wake_command]=WK_cmd_init_value;         // very long...
      EZRadio_CMD_Write(Wake_command);
      EZ_commands.arr[Power_command] |= 0x0002;                //switch on the wake-up timer
      EZRadio_CMD_Write(Power_command);
      //set next state
      EZ_state = EZMac_S_Idle;
      EZInternalState = EZ_Idle;
      #ifdef SM_PRINTF
       printf("WakeUp\n\r");
      #endif
      #ifdef SM_PRINT_STATE
       _PrintState();
      #endif
   break;

 /*channel check before receiving*/
   case EZ_RxDQDCheck:
      #ifdef SM_PRINTF
       printf("DQDCh\n\r");
      #endif
      #ifdef SM_PRINT_STATE
        _PrintState();
      #endif

      if( Data1 == 0 )
         {//it will be the first DQD
         //multiplex the DQD bit to the MISO pin
         SEL_PIN = 0;
         Spi_Comm0();
         }
         //is the DQD 1 or 0?
      //save DQD value: only the last logic high value of the DQD will increment the counter
      if( _DQD_Check() )
         Data++;
      else
         Data = 0;
      //increment the number of the sample counter
      Data1++;
      if(Data1 == DQD_SAMPLE)
      {//after sampling we should check the result
         //set the select pin
         SEL_PIN = 1;
         if( Data > 2)
         {//at least the last 3 DQD was logic high
            //we can receive any data; wait for IRQ -> after TIMER1 IT and the DQD is OK, or after EXT IT (the sync pattern is received)
            //Turn on the FIFO of Trixie
            #ifdef SM_REAL_FUNCTION
            EZ_commands.arr[Fifo_command] |= 0x0002;                      //enable synchron latch
            EZRadio_CMD_Write(Fifo_command);
            #endif
            clear_interrupt( INT_EXT );
            enable_interrupts( INT_EXT );
            //init CRC calculation routine
            Crc_Init();


            Data = EZ_reg.bits.MCRB.NRF + 7;                   //this will be the cycle counter of the CRL checking in the next state
                                                               //number of preamble + 3 (2D D4 and the first data byte)
            _Set_Timer1( 65535 - (ONE_BYTE_TIMER_LIMIT) );           //we will check the CRL bit 2.5ms later than we switched

            //next states will read data byte from the FIFO, the External Interrupt routine shouldn't set the SPI select pin!
            SetSpiEn = FALSE;

            //Set next state
            EZInternalState = EZ_RxCheckCID;
            EZ_state = EZMac_S_Receiving;
            FirstError = TRUE;
         }
         else
         {//DQD was logic low more than twice -> no valid FSK data
            Ch_Check_Start(TRUE);
         }
         //set the init values /*deleted by krk*/
         //Data = 0;
         //Data1 = 0;
      }
      else
         {
         //Start Timer1 -> read next sample of DQD
         _Set_Timer1(DQD_TIMER_LIMIT);
         }
   break;

 /*receiving the first byte*/
   case EZ_RxCheckCID:
      #ifdef SM_TRIGGER_CID
       TRIGGER = 1;
      #endif
      #ifdef SM_PRINTF
       printf("ChCID: ");
      #endif
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
         {                          //Timer IRQ -> CRL checking
            if (Data)               //cycle counter, check CRL until {Packet_Start_Timeout="number of preambles+3" (2D D4 and the first data byte)} ms
            {                       // in every ms
               Data--;
            SEL_PIN = 0;
            Spi_Comm0();
            CLK_PIN = 1;                           //go to the CRL bit (previously we were at DQD bit in the status)
            CLK_PIN = 0;

               if (MISO_PIN)      //Test Clock Recovery locked bit
               {
                  _Set_Timer1( 65535 - (CRL_CHECK_TIMER_LIMIT) );           //next round
                  SEL_PIN = 1;
                  break;

               }
            }
            //No clock recovery, we are receiving an FSK signal which is not sent for us, or the Packet_Start_Timeout ended. -> go away!
            SEL_PIN = 1;
            //go to the next channel
            Ch_Check_Start(TRUE);
         }
      else
         {//CID is in the FIFO
         //set the Soft WDTimer for RX
         #ifdef SM_SOFTWDT_EN
          //enable the software watchdog timer for receiving
          _Set_Timer1(MAX_RX_PACKET_TIMER);
         #endif
         //read the data from the Trixie (Data)
         #ifdef SM_REAL_FUNCTION
          Data = _ReadByte_Trixie();
         #else
          Data = 0xCD;            //only for test
         #endif

         #ifdef SM_PRINTF
          printf("%x\n\r",Data);
         #endif
         //check the CID
         if( ((EZ_reg.bits.PFCRB.CFEN && (Data == EZ_reg.bytes.CIDB)) || (!EZ_reg.bits.PFCRB.CFEN)) || EZ_reg.bits.PFCRB.PREN )
            {
            //save the byte
            EZ_reg.bytes.RX_CIDB = Data;
            EZInternalState = EZ_RxCheckSID;
            //Calc CRC
            Crc_On_Fly(Data);
            }
         else
            {
            //go to the next freq.
            Ch_Check_Start(TRUE);
            }
         }
   break;

 /*receiving the first or second byte*/
   case EZ_RxCheckSID:

      #ifdef SM_TRIGGER_SID
      TRIGGER = 1;                    //trigger output for oscilloscope
      #endif
      #ifdef SM_PRINTF
      printf("ChSID: ");
      #endif
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {                                   //SW Watchdog timer overrun
         _TrixieHWError();
      }
      else
      {                                   //SID received, read the data from the Trixie (Data)
         #ifdef SM_REAL_FUNCTION
         Data = _ReadByte_Trixie();
         #else
         Data = 0xF1;
         #endif

         #ifdef SM_PRINTF
         printf("%x\n\r",Data);
         #endif
         //check the SID
         AddrSID = FALSE;
         AddrDID = FALSE;
         //normal address mode
         if( (EZ_reg.bits.PFCRB.SFEN && ((EZ_reg.bytes.SFLTB & EZ_reg.bytes.SMSKB) == (Data & EZ_reg.bytes.SMSKB))) || !EZ_reg.bits.PFCRB.SFEN)
            AddrSID = TRUE;

         if( AddrSID || EZ_reg.bits.PFCRB.PREN )
         {                                            //the data is correct
            //save the byte
            EZ_reg.bytes.SIDB = Data;
            //Calc CRC
            Crc_On_Fly(Data);
            //set next state
            EZInternalState = EZ_RxCheckDID;
            return;
         }

         //address filter failure
         Ch_Check_Start(TRUE);                        //go to the next freq.
      }
      break;

 /*Receiving the DID byte*/
   case EZ_RxCheckDID:

      #ifdef SM_PRINTF
      printf("ChDID: ");
      #endif
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )   //SW Watchdog timer overrun -> Trixie HW error
      _TrixieHWError();
      else
      {                                //DID received, read the data from the Trixie (Data)
         #ifdef SM_REAL_FUNCTION
         Data = _ReadByte_Trixie();
         #else
         Data = 0xF2;
         #endif

         #ifdef SM_PRINTF
         printf("%x\n\r",Data);
         #endif
         AddrDID = FALSE;
         //DID filter
         if( !EZ_reg.bits.PFCRB.DFEN )
            AddrDID = TRUE;
         //self address filter
         if( EZ_reg.bytes.SFIDB == Data )
         {
            AddrDID = TRUE;
            EZ_reg.bits.RSRB.SELFA = 1;
         }
         //broadcast filter
         if( EZ_reg.bits.PFCRB.BCEN && (Data == 0xFF) )
         {
            AddrDID = TRUE;
            EZ_reg.bits.RSRB.BCA = 1;
         }

         //if the filtering passed
         if( AddrDID || EZ_reg.bits.PFCRB.PREN)
         {
            //save the data
            EZ_reg.bytes.DIDB = Data;
            //calc CRC
            Crc_On_Fly(Data);
            //set next state
            if( EZ_reg.bytes.RPLB < (PLEN_MAX + 1) )
            {
               DataByteCounter = 0;
               /*changed by krk for rev1.3 -> during rx the PLENB register will be not changed if fixed packet length is activated!*/
               //EZ_reg.bytes.PLENB = EZ_reg.bytes.RPLMPL;
               Data1 = EZ_reg.bytes.RPLB;
               EZInternalState = EZ_RxDataByte;
               return;
            }

         }
      }
      //addres filter failure, go to the next freq.
      Ch_Check_Start(TRUE);
      break;

 /*Receiving the Data bytes*/
   case EZ_RxDataByte:
   {
      #ifdef SM_PRINTF
      printf("RxD: ");
      #endif
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
         //SW Watchdog timer overrun -> Trixie HW error
      _TrixieHWError();
      else
      {//Data byte received, read the data from the Trixie (Data)
         #ifdef SM_REAL_FUNCTION
         Data = _ReadByte_Trixie();
         #else
         Data = DataByteCounter;
         #endif

         #ifdef SM_PRINTF
         printf("%x\n\r",Data);
         #endif
         //save Data
         EZ_reg.bytes.DBuff[DataByteCounter] = Data;
         //calc CRC
         Crc_On_Fly(Data);
         DataByteCounter++;
         //it was the last byte?
         /*changed by krk for rev1.3 -> during rx the PLENB register will be not changed if fixed packet length is activated!*/
         /*extra safety for rev1.5 by krk*/
         if( (DataByteCounter == Data1) || (DataByteCounter == PLEN_MAX) )//EZ_reg.bytes.PLENB )
         EZInternalState = EZ_RxCheckEDC;
      }
      break;
   }

 /*Receiving the EDC bytes*/
   case EZ_RxCheckEDC:
   {
      #ifdef SM_PRINTF
      printf("ChEDC: ");
      #endif
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )  //SW Watchdog timer overrun -> Trixie HW error
      _TrixieHWError();
      else
      {                                //EDC byte received, read the data from the Trixie (Data)
         #ifdef SM_REAL_FUNCTION
         Data = _ReadByte_Trixie();
         #else
         if( (DataByteCounter == (Data1 + 1)) || (DataByteCounter == PLEN_MAX + 1) ))
         //second CRC
         Data = 0x50;
         else
         //first CRC
         Data = 0x29;
         #endif
         #ifdef SM_PRINTF
         printf("%x\n\r",Data);
         #endif
         //Calc the CRC for the received CRC
         Crc_On_Fly(Data);
         DataByteCounter++;
         if(DataByteCounter == (Data1 + 2) || (DataByteCounter == PLEN_MAX + 2) ) //Is the second CRC byte arrived?
         {
            //Is the CRC correct?
            if(EZ_crc.adat == 0)
            {
               //turn off Trixie after correct Rx
              #ifdef ARSSI_USED
               ARSSI_value=(read_adc( ADC_READ_ONLY ));
               //switch off ADC, save current
               setup_adc( ADC_OFF );
              #else
               ARSSI_value = 0x23;
              #endif

              #ifdef SM_REAL_FUNCTION
               EZ_commands.arr[Fifo_command] &=0xFFFD;                            //reset synchron latch
               EZRadio_CMD_Write(Fifo_command);

               EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP;  //switch off TX latch, and RX FIFO
               EZRadio_CMD_Write(Config_command);

               EZ_commands.arr[Power_command] &= 0xff0f;                        //switch off receiver
               EZRadio_CMD_Write(Power_command);
               EZRadio_Statusread ();                          //reset all non latched IT in Trixie

               EZ_reg.bits.RSRB.PRF = Frequency & 0x07;
               EZ_state = EZMac_S_PacketValid;
              #endif
               EZInternalState = EZ_RxEnd;
               _Turn_Off_Timer1();
               disable_interrupts( INT_EXT );
               //next states will not read data bytes -> External Interrupt routine should set the SPI select pin
               SetSpiEn = TRUE;
            }
            else
            {//CRC error
               //go to the next freq
               Ch_Check_Start(TRUE);
            }
         }
         else
         {//first CRC byte
            //read out the DRSSI value from the Trixie (EZ_reg.bits.RSRB.DRSSI)
            #ifdef SM_REAL_FUNCTION
            EZ_reg.bits.RSRB.DRSSI = _DRSSI_Read();
            #endif
            if(EZ_reg.bits.MCRB.ADEN)
               {//start AD conversion to measure the ARSSI value
               /*changed by krk for rev 1.51 -> measure the ARSSI, start (only) the ADC*/
               #ifdef ARSSI_USED
                read_adc(ADC_START_ONLY);
               #endif
               }
         }
      }
      break;
   }

 /*End of the receiving*/
   case EZ_RxEnd:
      #ifdef SM_PRINTF
       printf("RxE\n\r");
      #endif
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
   break;

 /*Transmit error state*/
   case EZ_TransmitError:
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
      #ifdef SM_PRINTF_TX
       printf("TxE\n\r");
      #endif
   break;

 /*Channel check before transmit*/
   case EZ_TxCheckChannel:
   {
      #ifdef SM_TRIGGER_TX
      TRIGGER = 1;
      #endif
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      #ifdef SM_PRINTF_TX
      printf("TxChC\n\r");
      #endif
      if( It_Source != IT_SOURCE_T1 )
      {//HW error, not T1 IT
         _TrixieHWError();
         return;
      }
      //DQD check
      if( Data1 == 0 )              //this is the first DQD check round
      {
         //multiplex the DQD to the MISO pin
         SEL_PIN = 0;
         Spi_Comm0();
      }
      //save DQD value: only the last logic high value of the DQD will increment the counter
      if( _DQD_Check() )
         Data++;
      else
         Data = 0;
      //increment the sample counter
      Data1++;
      if(Data1 == DQD_SAMPLE)
      {                          //after sampling we should check the result
         SEL_PIN = 1;            //set the select pin
         #ifdef SM_REAL_FUNCTION
         EZ_commands.arr[Power_command] &= 0xff0f;                                          //switch off receiver
         EZRadio_CMD_Write(Power_command);
         #endif
         //is the DQD 1 or 0?
         if( Data > 2)
         {//channel occupied
            //go to the TxError state
            _GotoTxErrorState();
            return;
         }
         else
         {//the channel is IDLE, the packet can be sent
            // Configure Trixie to start TX
            #ifdef SM_REAL_FUNCTION
            EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP | TXREG_USED;       //switch on TX reg.
            EZRadio_CMD_Write(Config_command);
            EZ_commands.arr[Power_command] |= 0x0020;                                          //switch on the transmitter
            EZRadio_CMD_Write(Power_command);
            #endif
            #ifdef SM_TRIGGER_TX
            TRIGGER = 1;
            #endif
            //set next state
            EZ_state = EZMac_S_TxPacket;
            EZInternalState = EZ_TxSendPreamble;
            //setup SW Watchdog timer
            #ifdef SM_SOFTWDT_EN
            _Set_Timer1(MAX_TX_PACKET_TIMER);
            #endif
            //enable ext IT
            clear_interrupt( INT_EXT );
            enable_interrupts( INT_EXT );
         }
      }
      else
      {
         //next sample Start Timer1
         _Set_Timer1(DQD_TIMER_LIMIT);
      }

      break;
   }

 /*Send preamble bytes*/
   case EZ_TxSendPreamble:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if (It_Source == IT_SOURCE_T1)
      {                                //SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (0xAA) to the Trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (0xAA);
      #endif

      AddrSID = TRUE;
      #ifdef SM_PRINTF_TX
      printf("TxPre: AA\n\r");
      #endif
      if(DataByteCounter == 0)
         EZInternalState = EZ_TxSendSyncPattern0;
      else
         DataByteCounter--;
      break;
   }

 /*Send the first sync pattern: 2D, calc the CRC for the first header byte*/
   case EZ_TxSendSyncPattern0:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (0x2D) to the Trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (0x2d);
      #endif

      DataByteCounter = 0;
         //CID is used, this is the first byte of the header
      Data = EZ_reg.bytes.CIDB;
      //calc CRC for this byte
      Crc_On_Fly(Data);
      //go to the next state
      EZInternalState = EZ_TxSendSyncPattern1;
      #ifdef SM_PRINTF_TX
      printf("TxSy0: 2D %x\n\r",Data);
      #endif
      break;
   }

 /*Send the second sync pattern byte: D4, calc the CRC for the 2nd header byte*/
   case EZ_TxSendSyncPattern1:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (0xD4) to the Trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (0xd4);
      #endif

      //save the previosly calculated data byte
      Data1 = Data;
      //next state
      EZInternalState = EZ_TxSendHeader1;
      //the second header byte (H2)
      Data = EZ_reg.bytes.SIDB;
      //calc CRC for this byte
      Crc_On_Fly(Data);
      //the CRC was calculated for all of the databytes
      #ifdef SM_PRINTF_TX
      printf("TxSy1: D4 %x\n\r",Data);
      #endif
      break;
   }

 /*Send the 1. header byte...*/
   case EZ_TxSendHeader1:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (Data1) to the trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (Data1);
      #endif

      #ifdef SM_PRINTF_TX
      printf("TxH1: %x",Data1);
      #endif
      //save the previosly calculated data byte
      Data1 = Data;
      //next state
      EZInternalState = EZ_TxSendHeader2;
      //the 3d header byte (H3)
      Data = EZ_reg.bytes.DIDB;

      //calc CRC for this byte
      Crc_On_Fly(Data);
      //the CRC was calculated for all of the databytes
      #ifdef SM_PRINTF_TX
      printf(" %x\n\r",Data);
      #endif
      break;
   }

 /*Send the 2. header byte*/
   case EZ_TxSendHeader2:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (Data1) to the trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (Data1);
      #endif
      #ifdef SM_PRINTF_TX
      printf("TxH2: %x",Data1);
      #endif
      //save the previosly calculated data byte
      Data1 = Data;
      //next state
      EZInternalState = EZ_TxSendData;
      //fix packet length
      Data = EZ_reg.bytes.DBuff[DataByteCounter];
      DataByteCounter++;
      EZInternalState = EZ_TxSendData;
      //calc CRC for this byte
      Crc_On_Fly(Data);
      //the CRC was calculated for all of the databytes
      if( DataByteCounter == EZ_reg.bytes.PLENB )
         EZInternalState = EZ_TxCalcCrc;
      #ifdef SM_PRINTF_TX
      printf(" %x\n\r",Data);
      #endif
      break;
   }
 /*Send the data bytes*/
   case EZ_TxSendData:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (Data1) to the trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (Data1);
      #endif

      #ifdef SM_PRINTF_TX
      printf("TxD: %x",Data1);
      #endif
      //save the previosly calculated data byte
      Data1 = Data;
      //the new data byte
      Data = EZ_reg.bytes.DBuff[DataByteCounter];
      DataByteCounter++;
      //Calc CRC
      Crc_On_Fly(Data);
      if( DataByteCounter == EZ_reg.bytes.PLENB )
         EZInternalState = EZ_TxCalcCrc;
      #ifdef SM_PRINTF_TX
      printf(" %x\n\r",Data);
      #endif
      break;
   }
 /*Send the data bytes, calc the CRC for the CRC bytes (0x00)*/
   case EZ_TxCalcCrc:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (Data1) to the Trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (Data1);
      #endif

      #ifdef SM_PRINTF_TX
      printf("TxCCrc: %x\n\r",Data1);
      #endif
      //calc CRC
      Crc_On_Fly(0x00);
      //save the previosly calculated data byte
      Data1 = Data;
      EZInternalState = EZ_TxCalcCrc1;
      break;
   }
 /*Send the last data byte, calc the CRC*/
   case EZ_TxCalcCrc1:
   {
      #ifdef SM_PRINT_STATE
      _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
      {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
      }
      //write byte (Data1) to the Trixie
      #ifdef SM_REAL_FUNCTION
      _WriteByte_Trixie (Data1);
      #endif

      #ifdef SM_PRINTF_TX
      printf("TxCCrc1: %x\n\r",Data1);
      #endif
      //calc CRC
      Crc_On_Fly(0x00);
      //set the last 2 bytes
      Data = EZ_crc.bytes[0].adat;
      Data1 = EZ_crc.bytes[1].adat;
      EZInternalState = EZ_TxSendEdc;
      //One byte more should be copied to the FIFO to send the last byte correctly
      DataByteCounter = 2;
      break;
   }
 /*Send the CRC bytes*/
   case EZ_TxSendEdc:
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
      if( It_Source == IT_SOURCE_T1 )
         {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
         }
      //write byte (Data1) to the trixie
      #ifdef SM_REAL_FUNCTION
       _WriteByte_Trixie (Data1);
      #endif

      #ifdef SM_PRINTF_TX
       printf("TxEdc: %x\n\r",Data1);
      #endif
      Data1 = Data;
      if( DataByteCounter == 0 )
         //it was the last byte, end of Tx
         EZInternalState = EZ_TxEnd;
      else
         DataByteCounter--;
   break;

 /*End of the transmit*/
   case EZ_TxEnd:
      #ifdef SM_PRINT_STATE
         _PrintState();
      #endif
      #ifdef SM_DEBUG
       TRIGGER = 0;
      #endif
      #ifdef SM_PRINTF_TX
       printf("TxEnd\n\r");
      #endif
      if( It_Source == IT_SOURCE_T1 )
         {//SW Watchdog timer overrun -> Trixie HW error
         _TrixieHWError();
         return;
         }
      //turn off Trixie and go to Idle or Sleep state (depend on AXOT bit)
      EZMac_Idle();
   break;

   }
}

//===============================================================================================

// start new CRC calculation
void Crc_Init()
{
   // EZ_crc have to be initialized before the first CRC calculation
   EZ_crccnt = 0;
}

//===============================================================================================
#pragma separate
// Changed by Laszlo Kadar on 26.11.05
void Crc_On_Fly(int8 Data)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
   static _NEAR__ int8 BANK_2 bit_counter;
#endif
#ifdef CCS_C_COMPILER
   int8 bit_counter;
#endif

   #ifdef FIX_MEM_ADDRESS
    #pragma byte Data = 0x63
    #pragma byte bit_counter = 0x65;
   #endif

   if (EZ_crccnt<2)                        // first two bytes
   {
      if (EZ_crccnt==0)
      {
// Changed by Laszlo Kadar on 26.11.05
         EZ_crc.bytes[1].adat = Data; // first byte: CrcH
         EZ_crccnt++;
      }
      else
      { // crccnt ==1
// Changed by Laszlo Kadar on 26.11.05
         EZ_crc.bytes[0].adat = Data;   // second byte: CrcL
         EZ_crccnt++;
      }
   }
   else // bytes 3, 4...
   {
      for(bit_counter=8; bit_counter > 0; bit_counter--)
      {
         if(!EZ_crc.bytes[1].testreg.bit7)
            {
            EZ_crc.adat <<= 1;
// Changed by Laszlo Kadar on 26.11.05
            if(Data&0x80)
               EZ_crc.adat |= 0x0001;
// Changed by Laszlo Kadar on 26.11.05
            Data <<= 1;
            }
         else
            {
            EZ_crc.adat <<= 1;
// Changed by Laszlo Kadar on 26.11.05
            if(Data&0x80)
               EZ_crc.adat |= 0x0001;
// Changed by Laszlo Kadar on 26.11.05
            Data <<= 1;

            EZ_crc.adat ^= CRC_16_PATTERN;
            }
      }
   }
}

//===============================================================================================
#pragma separate
// Changed by Laszlo Kadar on 26.11.05
#ifdef HITECH_COMPILER
 #pragma interrupt_level 1
#endif
void _Set_Timer1(int16 Limit)
{
   #ifdef FIX_MEM_ADDRESS
    #pragma locate Limit = 0x68
   #endif
   /*changed by krk for rev1.6 -> clear the timer and flags before restart it*/
   _Turn_Off_Timer1();
   //set up Timer1 to wake up the state machine for various events
   setup_timer_1(T1_INTERNAL | T1_DIV_BY_8);      //internal oscillator (Fosc/4), prescaler = 8
   set_timer1(Limit);                             //setup the timer interval
   #ifdef SM_DEBUG                                //only for debug: show the start of the new timer interval
    TRIGGER2 = 0;                                 //help to measure the timer interval
    #asm
    nop
    #endasm
    TRIGGER2 = 1;
   #endif
   //enable the interrupt
   clear_interrupt(INT_TIMER1);
   enable_interrupts(INT_TIMER1);
}

//===============================================================================================
#ifdef CCS_C_COMPILER
 #pragma inline
#endif
void _Turn_Off_Timer1(void)
{  //turn of the Timer1
   setup_timer_1(T1_DISABLED);
   disable_interrupts(INT_TIMER1);
}

//===============================================================================================
#pragma separate
// Changed by Laszlo Kadar on 26.11.05
#ifdef HITECH_COMPILER
 #pragma interrupt_level 1
#endif
char EZRadio_CMD_Write (int8 CMD_index)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
   static _NEAR__ int16 BANK_2 EZcmd;
#endif
#ifdef CCS_C_COMPILER
   int16 EZcmd;
#endif

   EZcmd=EZ_commands.arr[CMD_index];
   //send a command for Trixie
   SEL_PIN = 0;                     //SPI sel pin = 0
   EZ_Spi_Write(EZcmd>>8);      //write high byte
   EZ_Spi_Write(EZcmd);         //write low byte
   SEL_PIN = 1;                     //set SPI sel pin
}

//===============================================================================================

#pragma separate
void EZ_Reg_Default(void)
{
// Changed by Laszlo Kadar on 29.11.05
#ifdef HITECH_COMPILER
   static _NEAR__ int8 BANK_2 i;
#endif
#ifdef CCS_C_COMPILER
   int8 i;
#endif

   EZ_state = EZMac_S_Sleep;                    //first state: Sleep
   EZInternalState = EZ_Sleep;

   for(i=MCR;i<PLEN;i++)
    EZMacReg_Write(i,0);                        //delete all registers, except the read only registers

   /*set the default values of the registers*/
   //AXOT = 1, LBTEN = 1, OutPow = min
   EZ_reg.bytes.TCRB = 0xF8;
   //AXOR = 1
   EZ_reg.bytes.RCRB = 0x80;
   //promiscuous mode
   EZ_reg.bytes.PFCRB = 0x02;
   //different freq in the freq register
   for(i=1;i<9;i++)
      EZ_reg.bytes.FR[i-1] = i;
   EZ_reg.bytes.CIDB = DEFAULT_CID;             //customers can set the default value of this registers
   EZ_reg.bytes.SFIDB = DEFAULT_SFID;           //see IAI_EZMac.h
   EZ_reg.bytes.SFLTB = DEFAULT_SFLT;
   EZ_reg.bytes.SMSKB = DEFAULT_SMSK;
   EZ_reg.bytes.RPLB = 0x01;
   SetSpiEn = TRUE;                             //External Interrupt routine should set the SPI select pin
}

//===============================================================================================

#pragma separate
void EZ_Radio_Config(void)
{
//changed by mlu for rev1.4

   EZ_commands.arr[Config_command]=0x8000 | FREQ_Band | XTAL_COMP;
   EZ_commands.arr[Power_command]=POW_cmd_init_value;             // switch everything off, also the clk output
   EZ_commands.arr[Fifo_command]=FIFO_cmd_init_value;             // Fill:synchron pattern; IT level:8; disable sensitive reset
   EZ_commands.arr[Data_Rate_command]=DR_cmd_init_value;          // 8842bps
   EZ_commands.arr[RX_Ctrl_command]=RX_cmd_init_value;            // BW:135kHz; VDI:always on; LNA:max; DRSSI:-103; Pin8: VDIout
   EZ_commands.arr[TX_Ctrl_command]=TX_cmd_init_value;            // f0+df; df:75kHz; Pout:min
   EZ_commands.arr[Data_Filter_command]=DF_cmd_init_value;        // CR:slow; Digital LPF; DQD:7
   EZ_commands.arr[AFC_command]=AFC_cmd_init_value;               // enabled; fine mode; auto,keep offset; +7/-8; output enabled
   EZ_commands.arr[Freq_command]=0xA000 + ((int16)(FREQ_maxid/2)*FREQ_step + FREQ_start);
   EZ_commands.arr[Wake_command]=WK_cmd_init_value;               // very long...
   EZ_commands.arr[Low_Duty_command]=LD_cmd_init_value;           // 10%, off
   EZ_commands.arr[LBD_command]=LB_cmd_init_value;                // uC clk:1MHz, threshold:2.2V

   EZRadio_CMD_Write(Power_command);
   EZRadio_CMD_Write(Config_command);
   EZRadio_CMD_Write(Fifo_command);
   EZRadio_CMD_Write(Data_Rate_command);
   EZRadio_CMD_Write(TX_Ctrl_command);
   EZRadio_CMD_Write(RX_Ctrl_command);
   EZRadio_CMD_Write(Data_Filter_command);
   EZRadio_CMD_Write(AFC_command);
   EZRadio_CMD_Write(Freq_command);
   EZRadio_CMD_Write(Wake_command);
   EZRadio_CMD_Write(Low_Duty_command);
   EZRadio_CMD_Write(LBD_command);
/*   Power_command |= 0x0010;                not needed, because it is automatic when switching on the TX or RX       //switch on the synthesizer for calibrating
   EZRadio_Write(Power_command);
   Power_command &= 0xff07;
   EZRadio_Write(Power_command);
*/
   EZRadio_Statusread ();
}


